<?php
include 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'] ?? '';
    $idade = $_POST['idade'] ?? '';
    $genero = $_POST['genero'] ?? '';
    $turma_id = $_POST['turma_id'] ?? '';
    $origem = 'anterior';

    if ($nome && $idade > 0 && $genero && $turma_id) {
        $stmt = $conn->prepare("INSERT INTO alunos (nome, idade, genero, turma_id, origem) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sisis", $nome, $idade, $genero, $turma_id, $origem);
        $stmt->execute();
        echo "<script>alert('Aluno salvo com sucesso! Redirecionando para visualização...'); window.location.href='ver_alunos_anteriores.php?turma_id=$turma_id';</script>";
        exit;
    } else {
        echo "<script>alert('Preencha todos os campos corretamente.');</script>";
    }
}

// Buscar turmas anteriores
$turmas = $conn->query("SELECT id, nome, ano FROM turmas_anteriores ORDER BY ano DESC, nome ASC");
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Cadastrar Aluno de Ano Anterior</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
        }
        .top-bar {
            background: #0056b3;
            color: white;
            padding: 15px;
            font-size: 18px;
        }
        .sidebar {
            width: 220px;
            background: #1c1c1c;
            height: 100vh;
            float: left;
            padding-top: 20px;
        }
        .sidebar a {
            display: block;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
        }
        .sidebar a:hover {
            background: #333;
        }
        .content {
            margin-left: 220px;
            padding: 20px;
            background: #f4f4f4;
            min-height: 100vh;
        }
        .form-box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 5px #ccc;
            max-width: 500px;
        }
        input, select {
            width: 100%;
            padding: 8px;
            margin: 6px 0;
        }
        button {
            padding: 10px 15px;
            background: #0056b3;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background: #004494;
        }
    </style>
</head>
<body>

<div class="top-bar">SISMAG - Cadastrar Aluno de Ano Anterior</div>

<div class="sidebar">
    <a href="painel_anteriores.php">🏠 Início</a>
    <a href="cadastrar_turma_anterior.php">🏫 Cadastrar Turma</a>
    <a href="cadastrar_disciplina_anterior.php">📚 Cadastrar Disciplinas</a>
    <a href="ver_alunos_anteriores.php">👨‍🎓 Ver Alunos Anteriores</a>
</div>

<div class="content">
    <div class="form-box">
        <h2>Novo Aluno de Ano Lectivo Anterior</h2>
        <form method="POST">
            <label>Nome:</label>
            <input name="nome" required>

            <label>Idade:</label>
            <input name="idade" type="number" min="1" required>

            <label>Género:</label>
            <select name="genero" required>
                <option value="">-- Selecione --</option>
                <option value="M">Masculino</option>
                <option value="F">Feminino</option>
            </select>

            <label>Turma:</label>
            <select name="turma_id" required>
                <option value="">-- Selecione uma turma --</option>
                <?php while ($t = $turmas->fetch_assoc()): ?>
                    <option value="<?= $t['id'] ?>"><?= $t['nome'] ?> (<?= $t['ano'] ?>)</option>
                <?php endwhile; ?>
            </select>

            <input type="hidden" name="origem" value="anterior">
            <button type="submit">Salvar</button>
        </form>
    </div>
</div>

</body>
</html>
